package gov.va.med.mhv.rxrefill.enums;

public enum CategoryTypeEnumeration {

    M("M", "Rx Medication"),
    OTC("OTC", "Over-the-Counter"),
    H("H", "Herbal"),
    S("S", "Supplement"),
    O("O", "Other");

    private final String value;
    private final String desc;

    CategoryTypeEnumeration(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String value() {
        return value;
    }
    
    public String getValue() {
		return value;
	}

	public String getDesc() {
		return desc;
	}

	public static String getValue(String v) {
        for (CategoryTypeEnumeration c: CategoryTypeEnumeration.values()) {
            if (c.toString().equalsIgnoreCase(v)) {
                return c.desc;
            }
        }
        return null;
        //throw new IllegalArgumentException(v);
    }

}
